Option Strict Off
Option Explicit On
Imports VB = Microsoft.VisualBasic
Imports GIGATMS.NF.MifareReader
Imports GIGATMS.NF.GNetPlus

Friend Class frmMain
    Inherits System.Windows.Forms.Form

    Public Id As Integer
    Private m_szROMType, m_szVersion As String
    Private m_szModuleName As String
    Private m_bDisableAutoMode As Boolean

    Public WithEvents MF5x1 As New GIGATMS.NF.MifareReader

    Private m_bNoChangeEvent As Boolean

    Private m_bIsShowCR As Boolean
    Private m_bIsGNetEvent As Boolean

    Private m_bIsSupportTransfer As Boolean
    Private m_szCaption As String

    Public Sub AddRecord(ByRef Action As Byte, ByRef iValue As Integer)
        Dim I As Integer, bBuffer() As Byte
        ReDim bBuffer(0 To 15)
        Dim bResult As Boolean

        modMifare.PushToByteArray(Id, bBuffer, I, True)
        bBuffer(I) = CByte("&H" & CStr(Second(Now)))
        bBuffer(I + 1) = CByte("&H" & CStr(Minute(Now)))
        bBuffer(I + 2) = CByte("&H" & CStr(Hour(Now)))
        bBuffer(I + 3) = CByte("&H" & CStr(Microsoft.VisualBasic.DateAndTime.Day(Now)))
        bBuffer(I + 4) = CByte("&H" & CStr(Month(Now)))
        bBuffer(I + 5) = CByte("&H" & CStr(Year(Now) - 2000))
        I += 6
        modMifare.PushToByteArray(CShort(Action), bBuffer, I, True)
        modMifare.PushToByteArray(iValue, bBuffer, I, True)
        modMifare.PushToByteArray(CInt(0), bBuffer, I, True)
        If m_szModuleName = "PCR310/PRW106/MFR350" Then ' for PRW106/PCR310 RWD
            bResult = MF5x1.AddRecord(bBuffer)
        End If
    End Sub

    Sub EnableAccess(ByRef bFlag As Boolean)
        Select Case MF5x1.mfCurrentClass
            Case iCardTypeConstants.MIFARE_UltraLight
                cmdMF5(4).Enabled = True ' read
                cmdMF5(6).Enabled = True ' write
                cmdMF5(5).Enabled = False ' value
                cmdMF5(8).Enabled = False ' condition
                cmdMF5(3).Enabled = False ' Authenticate
                optKEY(0).Enabled = False
                optKEY(1).Enabled = False
                cmbSector.Enabled = False
                cmbBlock.Enabled = True
                txtBlock.MaxLength = 8 ' 4 bytes pre 1 page
                txtBlock.Enabled = bFlag
                txtASCBlock.MaxLength = txtBlock.MaxLength / 2
                txtASCBlock.Enabled = bFlag
                CheckWritable()
            Case iCardTypeConstants.MIFARE_DESFire
                cmdMF5(4).Enabled = False ' read
                cmdMF5(6).Enabled = False ' write
                cmdMF5(5).Enabled = False ' value
                cmdMF5(8).Enabled = False ' condition
                cmdMF5(3).Enabled = False ' Authenticate
                optKEY(0).Enabled = False
                optKEY(1).Enabled = False
                cmbSector.Enabled = False
                cmbBlock.Enabled = False
            Case Else
                cmdMF5(4).Enabled = bFlag ' read
                cmdMF5(6).Enabled = bFlag ' write
                cmdMF5(5).Enabled = bFlag ' value
                cmdMF5(8).Enabled = bFlag ' condition
                txtBlock.MaxLength = 32 ' 16 bytes pre 1 block
                txtBlock.Enabled = bFlag
                txtASCBlock.MaxLength = txtBlock.MaxLength / 2
                txtASCBlock.Enabled = bFlag
                cmbBlock.Enabled = bFlag
                CheckWritable()
        End Select
    End Sub

    Public Sub OnMfError()
        Dim I As Short
        ' any erroy, all operator must restart
        For I = 1 To cmdMF5.Count - 1
            If I <> 7 And I <> 9 Then
                cmdMF5(I).Enabled = False
            End If
        Next I
        cmdValueEx.Enabled = False
        cmbSector.Enabled = False
        cmbBlock.Enabled = False
        optKEY(0).Enabled = False
        optKEY(1).Enabled = False
        txtBlock.Enabled = False
    End Sub

    Sub ResetStatus()
        Dim lab As System.Windows.Forms.Label

        For Each lab In labMF5
            lab.Text = ""
        Next lab
    End Sub

    Sub SetMaxBlock(ByRef MaxBlock As Short)
        Dim I As Short
        Dim lOldIndex As Integer

        lOldIndex = cmbBlock.SelectedIndex
        cmbBlock.Items.Clear()
        For I = 0 To MaxBlock - 1
            If MF5x1.mfCurrentClass <> iCardTypeConstants.MIFARE_UltraLight Then
                cmbBlock.Items.Add("Block " & CStr(I))
            Else
                cmbBlock.Items.Add("Page " & CStr(I))
            End If
        Next I

        If lOldIndex < cmbBlock.Items.Count And lOldIndex <> -1 Then
            cmbBlock.SelectedIndex = lOldIndex
        Else
            cmbBlock.SelectedIndex = 0
        End If
    End Sub

    Sub SetMaxSector(ByRef MaxSector As Short)
        Dim I As Short
        Dim lOldIndex As Integer

        lOldIndex = cmbSector.SelectedIndex
        cmbSector.Items.Clear()
        If MaxSector > 0 And MF5x1.mfCurrentClass <> iCardTypeConstants.MIFARE_UltraLight Then
            cmbSector.Enabled = True
            For I = 0 To MaxSector - 1
                cmbSector.Items.Add("Sector " & Str(I)) ' 1K & 4K
            Next I
            If lOldIndex < cmbSector.Items.Count And lOldIndex <> -1 Then
                cmbSector.SelectedIndex = lOldIndex
            Else
                cmbSector.SelectedIndex = 0
            End If
        Else
            cmbSector.Enabled = False
        End If
    End Sub

    Public Sub CheckWritable()
        Dim bDisabledWrite As Boolean
        If MF5x1.mfCurrentClass = iCardTypeConstants.MIFARE_UltraLight Then
        ElseIf cmbBlock.SelectedIndex = 0 And cmbSector.SelectedIndex = 0 Then
            bDisabledWrite = True
        ElseIf cmbBlock.SelectedIndex = (cmbBlock.Items.Count - 1) Then
            bDisabledWrite = True
        End If
        If bDisabledWrite Then
            'Can't Write or Set Value to Last Block
            cmdValueEx.Enabled = False ' ValueEx
            cmdMF5(5).Enabled = False 'Value
            cmdMF5(6).Enabled = False 'Write
        Else
            Select Case MF5x1.mfCurrentClass
                Case iCardTypeConstants.MIFARE_UltraLight, iCardTypeConstants.MIFARE_DESFire
                    cmdValueEx.Enabled = False
                    cmdMF5(5).Enabled = False   'Value
                Case Else
                    cmdValueEx.Enabled = cmbBlock.Enabled And m_bIsSupportTransfer
                    cmdMF5(5).Enabled = cmbBlock.Enabled    'Value
            End Select
            cmdMF5(6).Enabled = cmbBlock.Enabled        'Write
        End If
    End Sub

    Private Sub cmbBlock_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmbBlock.SelectedIndexChanged
        CheckWritable()
    End Sub

    Private Sub cmbSector_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmbSector.SelectedIndexChanged
        EnableAccess(False)
        If cmbSector.SelectedIndex < 32 Then
            SetMaxBlock(4) ' MIFARE 1K
        Else
            SetMaxBlock(16) ' MIFARE 4K after sector 32
        End If
    End Sub

    Private Sub cmdAutoScan_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdAutoScan.Click
        Dim I, nPort As Short
        Dim nEvent As Short
        Dim iBaudrates(0 To 4) As Integer
        Dim b As Short
        Dim bIsFound As Boolean
        Dim dblVersion As Double
        Dim iCurBaudrate As Integer

        cmdAutoScan.Enabled = False

        m_bDisableAutoMode = False

        iBaudrates(0) = 19200
        iBaudrates(1) = 38400
        iBaudrates(2) = 9600
        iBaudrates(3) = 57600
        iBaudrates(4) = 115200

        ' Clear all status label
        ResetStatus()
        Call OnMfError()

        ' Disable Command Box
        cmdMF5(0).Enabled = False
        txtBlock.Text = vbNullString
        labVersion.Visible = False

        If MF5x1.PortOpen Then
            MF5x1.PortOpen = False
            System.Threading.Thread.Sleep(100)
        End If

        ' Show Version
        Me.Text = m_szCaption
        For I = 0 To 255 ' Loop by Comm Port
            nPort = MF5x1.EnumCommPortNum(I)
            If nPort > 0 Then
                MF5x1.CommPort = nPort
                For b = 0 To UBound(iBaudrates) ' Loop by Baudrate
                    iCurBaudrate = iBaudrates(b)
                    MF5x1.Settings = CStr(iCurBaudrate)
                    If MF5x1.PortOpen Then
                        MF5x1.PortOpen = False
                        System.Threading.Thread.Sleep(50)
                    End If
                    MF5x1.PortOpen = True
                    If MF5x1.PortOpen Then
                        nEvent = MF5x1.Polling(0) ' Addr=0 (Broadcast)
                        If nEvent <> -1 Then
                            m_szVersion = MF5x1.GetVersion ' Get RWD version for make sure are AC906
                            m_szROMType = VB.Left(m_szVersion, InStr(1, m_szVersion & " ", " ", CompareMethod.Text) - 1)
                            dblVersion = Val(Mid(m_szVersion, InStr(1, m_szVersion, "V", CompareMethod.Text) + 1))
                            dblVersion = dblVersion + Val(Mid(m_szVersion, InStr(1, m_szVersion, "R", CompareMethod.Text) + 1)) / 100000.0#
                            MF5x1.mfAutoMode()
                            Select Case m_szROMType
                                Case "PGM0488", "PGM-T0488" ' AC906
                                    m_szModuleName = "AC906"
                                    bIsFound = True
                                Case "PGM0487", "PGM-T0487" ' PCR310/PRW106/MFR350
                                    m_szModuleName = "PCR310/PRW106/MFR350"
                                    bIsFound = True
                                Case "PGM0494", "PGM-T0494" ' RWD906
                                    m_szModuleName = "RWD906-00"
                                    bIsFound = True
                                Case "PGM0517", "PGM-T0517" ' RWD906-UT
                                    m_szModuleName = "RWD906-UT"
                                    bIsFound = True
                                Case "PGM0499", "PGM-T0499" ' MF5
                                    m_szModuleName = "MF5"
                                    If dblVersion >= 1.3 Then
                                        m_bIsSupportTransfer = True
                                    End If
                                    bIsFound = True
                                Case "PGM-T0748"    ' DF5
                                    m_szModuleName = "DF5"
                                    m_bIsSupportTransfer = True
                                    bIsFound = True
                                Case "PGM-T0985"    ' MF6
                                    m_szModuleName = "MF6"
                                    m_bIsSupportTransfer = True
                                    bIsFound = True
                                Case "PGM-T0811"    ' MF10 with baudrate 57600
                                    m_szModuleName = "MF10"
                                    bIsFound = True
                                Case "ROM-T0636"    ' MF5 with baudrate 9600
                                    m_szModuleName = "MF5-01 (ODM)"
                                    bIsFound = True
                                Case "PGM-T0668"
                                    m_szModuleName = "MF5-02 (ODM)"
                                    bIsFound = True
                                Case "PGM-T0593"    ' PCR216
                                    m_szModuleName = "PCR216"
                                    bIsFound = True
                                Case "PGM-T0583"    ' MF700-00
                                    m_szModuleName = "MF700-00"
                                    m_bDisableAutoMode = True
                                    bIsFound = True
                                Case "PGM-T0604", "PGM-T0724", "PGM-T1023", "PGM-T1000" ' MF700-10
                                    m_szModuleName = "MF700-10"
                                    m_bDisableAutoMode = True
                                    bIsFound = True
                                Case "PGM-T0633"    ' MF700-30
                                    m_szModuleName = "MF700-30"
                                    m_bDisableAutoMode = True
                                    bIsFound = True
                                Case "PGM-T0605"    ' RWD145-00
                                    m_szModuleName = "RWD145-00"
                                    bIsFound = True
                                Case "PGM-T0829"    ' MF700-AB
                                    m_szModuleName = "MF700-AB"
                                    If dblVersion >= 1.000002 Then
                                        m_bIsSupportTransfer = True
                                    End If
                                    bIsFound = True
                                Case "PGM-T0830"    ' MF12-00
                                    m_szModuleName = "MF12-00"
                                    bIsFound = True
                                Case "PGM-T1039"    ' MF12-01
                                    m_szModuleName = "MF12-01"
                                    bIsFound = True
                                Case "PGM-T0843"    ' MF700-DK
                                    m_szModuleName = "MF700-DK"
                                    bIsFound = True
                                Case "PGM-T0987"    ' MF700-STF
                                    m_szModuleName = "MF700-STF"
                                    m_bIsSupportTransfer = True
                                    m_bDisableAutoMode = True
                                    bIsFound = True
                                Case "PGM-T0995"    ' RF30
                                    m_szModuleName = "RF30"
                                    m_bIsSupportTransfer = True
                                    bIsFound = True
                                Case "PGM-T0985"    ' MF6
                                    m_szModuleName = "MF6"
                                    m_bIsSupportTransfer = True
                                    bIsFound = True
                                Case "PGM-T0999"    ' DF700
                                    m_szModuleName = "DF700"
                                    m_bIsSupportTransfer = True
                                    bIsFound = True
                                Case "PGM-T1030", "PGM-T1031"   ' DF750
                                    m_szModuleName = "DF750"
                                    m_bIsSupportTransfer = True
                                    bIsFound = True
                            End Select
                        End If
                    End If
                    If bIsFound Then Exit For
                Next b
            End If
            If bIsFound Then Exit For
            MF5x1.PortOpen = False
        Next I
        If bIsFound Then
            If m_bDisableAutoMode Then
                'Disable Auto Mode
                MF5x1.mfAutoMode(False)
            End If

            cmdMF5(0).Enabled = True
            labVersion.Visible = True
            If iCurBaudrate = 19200 Then
                labVersion.Text = "Reader Version: " & m_szVersion
                Me.Text = m_szCaption & " - Mifare Reader On COM" & MF5x1.CommPort
            Else
                labVersion.Text = "Reader(" & iCurBaudrate & " bps) Version: " & m_szVersion
                Me.Text = m_szCaption & " - Mifare Reader On COM" & MF5x1.CommPort
            End If
            cmdMF5(7).Enabled = True
            cmdMF5(9).Enabled = True
        Else
            MsgBox("No RWD on serial prot!!", MsgBoxStyle.OkOnly Or MsgBoxStyle.Exclamation)
        End If
        cmdAutoScan.Enabled = True
    End Sub

    Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
        Me.Close()
    End Sub

    Public Sub cmdMF5_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdMF5.Click
        Dim Index As Short = cmdMF5.GetIndex(eventSender)
        Dim nResult As Short
        Dim bResult As Boolean
        Dim sResult As String
        Dim BlkNum As Short
        Dim bBuffer() As Byte

        BlkNum = cmbBlock.SelectedIndex

        Dim szKey As String
        Dim bCancelEnter As Boolean
        Select Case Index
            Case 0 ' Request ---------------------------
                ResetStatus() ' Clear all status label
                Call OnMfError()

                nResult = MF5x1.mfRequest ' Answer & Request, return card class
                If nResult > 0 Then
                    labMF5(0).ForeColor = System.Drawing.ColorTranslator.FromOle(QBColor(2))
                    labMF5(0).Text = MF5x1.mfCurrentClassStr
                    cmdMF5(1).Enabled = True
                Else
                    labMF5(0).ForeColor = System.Drawing.ColorTranslator.FromOle(QBColor(12))
                    labMF5(0).Text = MF5x1.GNetErrorCodeStr
                End If

            Case 1 ' Anticollision-----------------------
                Id = MF5x1.mfAnticollision
                If Id <> 0 Then
                    labMF5(1).ForeColor = System.Drawing.ColorTranslator.FromOle(QBColor(2))
                    Select Case MF5x1.mfCurrentClass
                        Case iCardTypeConstants.MIFARE_UltraLight, iCardTypeConstants.MIFARE_DESFire
                            labMF5(1).Text = VB.Left(Id.ToString("X").PadLeft(8, "0"), 6)
                        Case Else
                            labMF5(1).Text = Id.ToString("X").PadLeft(8, "0")
                    End Select
                    cmdMF5(2).Enabled = True
                Else
                    labMF5(1).ForeColor = System.Drawing.ColorTranslator.FromOle(QBColor(12))
                    labMF5(1).Text = MF5x1.GNetErrorCodeStr
                    Call OnMfError()
                End If

            Case 2 ' Select Card-------------------------
                nResult = MF5x1.mfSelectCard(Id)

                If nResult > 0 Then
                    labMF5(2).ForeColor = System.Drawing.ColorTranslator.FromOle(QBColor(2))
                    labMF5(2).Text = "PICC:" & nResult
                    cmdMF5(3).Enabled = True
                    cmbSector.Enabled = True
                    optKEY(0).Enabled = True
                    optKEY(1).Enabled = True
                    ' Check Card Type
                    Select Case MF5x1.mfCurrentClass
                        Case iCardTypeConstants.MIFARE_UltraLight, iCardTypeConstants.MIFARE_DESFire
                            labMF5(1).Text = MF5x1.mfAnticollision2.ToString("X").PadLeft(8, "0") & VB.Left(Id.ToString("X").PadLeft(8, "0"), 6)
                            SetMaxBlock(16) ' 16 page
                            SetMaxSector(0)
                            EnableAccess(True)

                        Case iCardTypeConstants.MIFARE_1K
                            'SetMaxBlock 4
                            SetMaxSector(16) ' Max 16 Sector

                        Case iCardTypeConstants.MIFARE_4K
                            'SetMaxBlock 4
                            SetMaxSector(40) ' Max 40 Sector
                    End Select

                Else
                    labMF5(2).ForeColor = System.Drawing.ColorTranslator.FromOle(QBColor(12))
                    labMF5(2).Text = MF5x1.GNetErrorCodeStr
                    Call OnMfError()
                End If

            Case 3 ' Authenticate, using EEPROM key
                Select Case cmbSector.SelectedIndex
                    Case 0 To 15
                        szKey = vbNullString 'Authenticate Key by Save Key
                    Case Else
                        szKey = frmEnterKey.GetKey
                        If szKey = vbNullString Then
                            'No Enter any Key
                            bCancelEnter = True
                        End If
                End Select

                If bCancelEnter = False Then
                    If optKEY(0).Checked Then
                        bResult = MF5x1.mfAuthenticate(cmbSector.SelectedIndex, bKeyTypeConstants.KEY_A, szKey)
                    Else
                        bResult = MF5x1.mfAuthenticate(cmbSector.SelectedIndex, bKeyTypeConstants.KEY_B, szKey)
                    End If

                    If bResult Then
                        labMF5(3).ForeColor = System.Drawing.ColorTranslator.FromOle(QBColor(2))
                        labMF5(3).Text = "Pass"
                        EnableAccess(True) ' To enable read/write/value etc. button
                    Else
                        labMF5(3).ForeColor = System.Drawing.ColorTranslator.FromOle(QBColor(12))
                        labMF5(3).Text = MF5x1.GNetErrorCodeStr
                        EnableAccess(False) ' To disable read/write/value etc. button
                        Call OnMfError()
                    End If
                End If

            Case 4 ' Read Block Data, using Hex String
                bResult = False
                ReDim bBuffer(0 To 15)
                If MF5x1.mfRead(BlkNum, bBuffer) Then
                    sResult = modMifare.BytesToHex(bBuffer)
                    bResult = True
                    If MF5x1.mfCurrentClass = iCardTypeConstants.MIFARE_UltraLight Then
                        txtBlock.Text = Mid(sResult, 1, 8)
                    Else
                        txtBlock.Text = sResult
                    End If
                End If

                If Len(txtBlock.Text) > 0 And bResult Then
                    labMF5(6).ForeColor = System.Drawing.ColorTranslator.FromOle(QBColor(2))
                    labMF5(6).Text = "Ok"
                Else
                    labMF5(6).ForeColor = System.Drawing.ColorTranslator.FromOle(QBColor(12))
                    labMF5(6).Text = MF5x1.GNetErrorCodeStr
                    Call OnMfError()
                End If

            Case 6 ' Write Block Data, using Hex String

                bBuffer = modMifare.HexToBytes(txtBlock.Text)
                If MF5x1.mfWrite(BlkNum, bBuffer) Then
                    labMF5(4).ForeColor = System.Drawing.ColorTranslator.FromOle(QBColor(2))
                    labMF5(4).Text = "Ok"
                Else
                    labMF5(4).ForeColor = System.Drawing.ColorTranslator.FromOle(QBColor(12))
                    labMF5(4).Text = MF5x1.GNetErrorCodeStr
                    Call OnMfError()
                End If

            Case 7 ' Halt ----------------------------
                MF5x1.mfHalt()
                EnableAccess(False)
                ResetStatus()

                If m_bDisableAutoMode Then
                    'Disable Auto Mode
                    MF5x1.mfAutoMode(False)
                End If
            Case 5
                frmValue.Show(Me)
            Case 8
                frmAccess.Show(Me)
            Case 9
                frmSaveKey.Show(Me)
        End Select
    End Sub

    Private Sub cmdValueEx_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdValueEx.Click
        frmValueEx.ShowValueOpt(MF5x1, cmbBlock, cmbSector.SelectedIndex)
    End Sub

    Private Sub frmMain_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
        Dim p As Short
        Dim strPort As String

        ' select last time comm port
        On Error Resume Next
        MF5x1.CommPort = CShort(GetSetting(My.Application.Info.Title, "COMM", "PORT", CStr(1)))

        ' show version
        With My.Application.Info.Version
            m_szCaption = Me.Text & "V" & .Major & "." & .Minor & "R" & .Revision
        End With
        Me.Text = m_szCaption

        cmbSector.SelectedIndex = 0
        cmbBlock.SelectedIndex = 0

        modMifare.LoadFormPosision(Me)
        m_bNoChangeEvent = False
    End Sub

    Private Sub frmMain_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        Dim oform As System.Windows.Forms.Form

        SaveSetting(My.Application.Info.Title, "COMM", "PORT", CStr(MF5x1.CommPort))
        modMifare.SaveFormPosision(Me)

        For Each oform In My.Application.OpenForms
            Try
                oform.Dispose()
            Catch ex As Exception

            End Try
        Next oform
    End Sub

    Private Sub Text1_DoubleClick(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Text1.DoubleClick
        Text1.Text = vbNullString
    End Sub

    Private Sub txtASCBlock_TextChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles txtASCBlock.TextChanged
        If m_bNoChangeEvent = False Then
            m_bNoChangeEvent = True
            With txtBlock
                .Text = VB.Left(modMifare.StringToHex(txtASCBlock.Text) & New String("0", .MaxLength), .MaxLength)
            End With
            m_bNoChangeEvent = False
        End If
    End Sub

    Private Sub txtASCBlock_KeyPress(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.KeyPressEventArgs) Handles txtASCBlock.KeyPress
        Dim KeyAscii As Short = Asc(eventArgs.KeyChar)
        Dim lLen As Integer
        With txtASCBlock
            lLen = modMifare.LenX(.Text)
            Select Case KeyAscii
                Case 0 To 31 'ASCII Control Char
                Case 32 To 255 'ASCII
                    lLen = lLen + 1
                Case Else 'DBCS
                    lLen = lLen + 2
            End Select
            If (lLen - .SelectionLength) > .MaxLength Then
                KeyAscii = 0
            End If
        End With
        eventArgs.KeyChar = Chr(KeyAscii)
        If KeyAscii = 0 Then
            eventArgs.Handled = True
        End If
    End Sub

    Private Sub txtBlock_TextChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles txtBlock.TextChanged
        If m_bNoChangeEvent = False Then
            m_bNoChangeEvent = True
            txtASCBlock.Text = modMifare.HexToString(txtBlock.Text)
            m_bNoChangeEvent = False
        End If
    End Sub

    Private Sub txtBlock_KeyPress(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.KeyPressEventArgs) Handles txtBlock.KeyPress
        Dim KeyAscii As Short = Asc(eventArgs.KeyChar)
        Select Case KeyAscii
            Case Is < 32
            Case &H30S To &H39S, &H41S To &H46S '0~9,A~F
            Case &H61S To &H66S 'a~f
                KeyAscii = KeyAscii - 32
            Case Else
                KeyAscii = 0
        End Select
        eventArgs.KeyChar = Chr(KeyAscii)
        If KeyAscii = 0 Then
            eventArgs.Handled = True
        End If
    End Sub

    Public Sub ShowMsg(ByVal szData As String, Optional ByVal bNewLine As Boolean = True)
        Dim L As Integer, iLen As Integer
        Dim szTemp As String
        With Text1
            szTemp = .Text
            iLen = Len(szTemp)
            If Not (iLen = 0 AndAlso szData = vbCrLf) Then
                .SelectionStart = iLen
                If bNewLine AndAlso VB.Right(szTemp, 2) <> vbCrLf AndAlso iLen > 0 Then
                    .SelectedText = vbCrLf
                ElseIf m_bIsShowCR Then
                    .SelectedText = vbCrLf
                    m_bIsShowCR = False
                End If
                .SelectedText = szData
                If bNewLine Then
                    .SelectedText = vbCrLf
                End If
                szTemp = .Text
                If Len(szTemp) > 5210 Then
                    L = InStr(2048, szTemp, vbCrLf, CompareMethod.Text)
                    If L <= 0 Then L = 2048
                    szTemp = Mid(szTemp, L)
                    .Text = szTemp
                    .SelectionStart = Len(szTemp)
                End If
            End If
        End With
    End Sub

    Private Function GetASCIIName(ByVal bChar As Byte) As String
        Dim szResult As String
        szResult = vbNullString
        Select Case bChar
            Case 0 : szResult = "NUL"
            Case 1 : szResult = "SOH"
            Case 2 : szResult = "STX"
            Case 3 : szResult = "ETX"
            Case 4 : szResult = "EOT"
            Case 5 : szResult = "ENQ"
            Case 6 : szResult = "ACK"
            Case 7 : szResult = "BEL"
            Case 8 : szResult = "BS"
            Case 9 : szResult = "TAB"
            Case 10 : szResult = "LF"
            Case 11 : szResult = "VT"
            Case 12 : szResult = "FF"
            Case 13 : szResult = "CR"
            Case 14 : szResult = "SO"
            Case 15 : szResult = "SI"
            Case 16 : szResult = "DLE"
            Case 17 : szResult = "DC1"
            Case 18 : szResult = "DC2"
            Case 19 : szResult = "DC3"
            Case 20 : szResult = "DC4"
            Case 21 : szResult = "NAK"
            Case 22 : szResult = "SYN"
            Case 23 : szResult = "ETB"
            Case 24 : szResult = "CAN"
            Case 25 : szResult = "EM"
            Case 26 : szResult = "SUB"
            Case 27 : szResult = "ESC"
            Case 28 : szResult = "FS"
            Case 29 : szResult = "GS"
            Case 30 : szResult = "RS"
            Case 31 : szResult = "US"
            Case 32 : szResult = "(SP)"
            Case 128 To 254
                szResult = "0x" & VB.Right(VB.Hex(&H0 + bChar), 2)
            Case Is < 128
                szResult = VB.Chr(bChar)
            Case Else
                szResult = vbNullString
        End Select
        Return szResult
    End Function

    Private Sub MF5x1_OnComm() Handles MF5x1.OnComm
        Dim bBuffers() As Byte
        Dim I As Short
        Dim bIsEventMode As Boolean
        If MF5x1.CommEvent = CommEventConstants.comEvReceive Then
            bBuffers = MF5x1.Input
            If optEventMode(0).Checked Then
                bIsEventMode = True
            End If
            For I = 0 To UBound(bBuffers)
                If bIsEventMode Then
                    Select Case bBuffers(I)
                        Case 3  ' ETX
                            If m_bIsGNetEvent Then
                                m_bIsGNetEvent = False
                                m_bIsShowCR = False
                                ShowMsg("<" & GetASCIIName(bBuffers(I)) & ">", False)
                                ShowMsg(vbCrLf, False)
                            Else
                                ShowMsg("<" & GetASCIIName(bBuffers(I)) & ">", False)
                            End If
                        Case 13 ' CR
                            ShowMsg("<" & GetASCIIName(bBuffers(I)) & ">", False)
                            m_bIsShowCR = True
                        Case 10 ' LF
                            If m_bIsShowCR Then
                                m_bIsShowCR = False
                                ShowMsg("<" & GetASCIIName(bBuffers(I)) & ">", False)
                                ShowMsg(vbCrLf, False)
                            Else
                                ShowMsg("<" & GetASCIIName(bBuffers(I)) & ">", False)
                            End If
                        Case 33 To 127
                            ShowMsg(VB.Chr(bBuffers(I)), False)
                        Case Else
                            ShowMsg("<" & GetASCIIName(bBuffers(I)) & ">", False)
                    End Select
                Else
                    Select Case bBuffers(I)
                        Case 2  ' STX
                            ShowMsg(vbCrLf, False)
                            ShowMsg(VB.Right(Hex(&H100S + bBuffers(I)), 2) & " ", False)
                        Case 3  ' ETX
                            If m_bIsShowCR Then
                                m_bIsShowCR = False
                                ShowMsg(VB.Right(Hex(&H100S + bBuffers(I)), 2) & " ", False)
                                ShowMsg(vbCrLf, False)
                            Else
                                ShowMsg(VB.Right(Hex(&H100S + bBuffers(I)), 2) & " ", False)
                            End If
                        Case 13 ' CR
                            ShowMsg(VB.Right(Hex(&H100S + bBuffers(I)), 2) & " ", False)
                            m_bIsShowCR = True
                        Case 10 ' LF
                            If m_bIsShowCR Then
                                m_bIsShowCR = False
                                ShowMsg(VB.Right(Hex(&H100S + bBuffers(I)), 2) & " ", False)
                                m_bIsShowCR = True
                            Else
                                ShowMsg(VB.Right(Hex(&H100S + bBuffers(I)), 2) & " ", False)
                            End If
                        Case Else
                            ShowMsg(VB.Right(Hex(&H100S + bBuffers(I)), 2) & " ", False)
                    End Select
                End If
            Next I
        End If
    End Sub

    Private Sub MF5x1_OnGNetEvent(ByVal szEvent As String) Handles MF5x1.OnGNetEvent
        ShowMsg(vbCrLf, False)
        ShowMsg("<STX>" & VB.Replace(szEvent, VB.Chr(3), "<ETX>") & "<CR>", False)
        m_bIsShowCR = True
        m_bIsGNetEvent = True
    End Sub

    Private Sub MF5x1_OnGNetPlus(ByVal iEvent As Integer) Handles MF5x1.OnGNetPlus
        Select Case iEvent
            Case 33 To 127
                ShowMsg("OnGNetPlus - Code:=0x" & VB.Hex(iEvent) & "(" & VB.Chr(iEvent) & ")")
            Case Else
                ShowMsg("OnGNetPlus - Code:=0x" & VB.Hex(iEvent))
        End Select
    End Sub

    Private Sub MF5x1_OnPort(ByVal iAction As GIGATMS.NF.GNetPlus.CommPortEventConstants, ByVal CommPort As String) Handles MF5x1.OnPort
        If iAction = CommPortEventConstants.comEvRemoveClosed Then
            Me.Text = m_szCaption
            ResetStatus() ' Clear all status label
            Call OnMfError()
            cmdMF5(7).Enabled = False
            cmdMF5(9).Enabled = False
            ShowMsg("Port Remove(" & CommPort & ")")
        End If
    End Sub

    Private Sub MF5x1_OnReaderEvent(ByVal iReaderEvent As GIGATMS.NF.MifareReader.iReaderEventConstants) Handles MF5x1.OnReaderEvent
        Select Case iReaderEvent
            Case iReaderEventConstants.READER_CARD_PRESENT
                ShowMsg("Card Present")
            Case iReaderEventConstants.READER_CARD_REMOVE
                ShowMsg("Card Remove")
                ResetStatus() ' Clear all status label
                Call OnMfError()
            Case iReaderEventConstants.READER_KEY_PRESS
                ShowMsg("Hot-Key Press")
            Case iReaderEventConstants.READER_ON_IRQ
                ShowMsg("On IRQ")
        End Select
    End Sub

    Private Sub optEventMode_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles optEventMode.Click
        Dim Index As Short = optEventMode.GetIndex(sender)
        If Index = 1 Then
            MF5x1.GNetEvent = GNetEventConstants.GNetEvent_GNetPlus
        Else
            MF5x1.GNetEvent = GNetEventConstants.GNetEvent_Both
        End If
    End Sub
End Class